/*
 * @(#)SimulatedElement.java  1.0  5. April 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.simulation;

import org.jhotdraw.xml.DOMStorable;
import java.beans.*;
import java.util.*;
/**
 * This is the interface for a SimulatedElement.
 * <p>
 * SimulatedElement's can be connected with other SimulatedElement's using
 * SimulatedRelationship's.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 5. April 2006 Created.
 */
public interface SimulatedElement extends SimulatedObject {
    
    // CONNECTION SUPPORT
    /**
     * Adds a relationship to the element.
     */
    public void addRelationship(SimulatedRelationship relationship);
    
    /**
     * Removes a relationship from the element.
     * The element fires an elementChanged event to all ElementListeners.
     */
    public void removeRelationship(SimulatedRelationship relationship);

    /**
     * Returns an immutable collection of the relationships of this element.
     */
    public List<SimulatedRelationship> getRelationships();
    /**
     * Returns an immutable collection of the related elements.
     */
    public List<SimulatedElement> getRelatedElements();
    /**
     * Returns an immutable collection of the reletionships of this element which
     * reflect the specified simulated concept.
     */
    public List<SimulatedRelationship> getRelationships(int simulatedConcept);
    /**
     * Returns an immutable collection of the elements that are related with
     * this element by the the specified simulated concept.
     */
    public List<SimulatedElement> getRelatedElements(int simulatedConcept);
    
    /**
     * Returns true if this element can have connections.
     */
    public boolean canConnect();
}
